/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.particle;

import com.dfdyz.epicacg.client.render.EpicACGRenderType;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MyTextureSheetParticle
extends SingleQuadParticle {
    protected final int maxframe;
    protected final ResourceLocation texture;

    protected MyTextureSheetParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, ResourceLocation texture) {
        super(level, x, y, z, xd, yd, zd);
        this.maxframe = (int)yd;
        this.texture = texture;
        this.m_107257_((int)zd);
    }

    protected float m_5970_() {
        return 0.0f;
    }

    protected float m_5952_() {
        return 0.0f;
    }

    protected float m_5951_() {
        return 0.0f;
    }

    protected float m_5950_() {
        return 0.0f;
    }

    public void m_5989_() {
        if (this.f_107224_++ > this.f_107225_) {
            this.m_107274_();
        }
    }

    public ParticleRenderType m_7556_() {
        return EpicACGRenderType.getRenderTypeByTexture(this.texture);
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float pt) {
        RenderUtils.GLSetTexture(this.texture);
        Vec3 vec3 = camera.m_90583_();
        float rt = ((float)this.f_107224_ + pt) / (float)this.f_107225_;
        float f = (float)(Mth.m_14139_((double)pt, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pt, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pt, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternion = camera.m_253121_();
        Vector3f[] vertexes = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = 0.8f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vertexes[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        int t = Math.min(this.maxframe - 1, (int)Math.floor(rt * (float)this.maxframe));
        float per = 1.0f / (float)this.maxframe;
        float u0 = (float)t * per;
        float u1 = (float)(t + 1) * per;
        float v0 = 0.0f;
        float v1 = 1.0f;
        int light = this.m_6355_(pt);
        buffer.m_5483_((double)vertexes[0].x(), (double)vertexes[0].y(), (double)vertexes[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertexes[1].x(), (double)vertexes[1].y(), (double)vertexes[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertexes[2].x(), (double)vertexes[2].y(), (double)vertexes[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertexes[3].x(), (double)vertexes[3].y(), (double)vertexes[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public boolean shouldCull() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BlackKnightProvider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new MyTextureSheetParticle(worldIn, x, y + 0.5, z, 0.0, 7.0, 10.0, EpicACGRenderType.BLACK_KNIGHT_PARTICLE_TEX);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BloodThirstyProvider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new MyTextureSheetParticle(worldIn, x, y + 0.5, z, 1.0, 6.0, 10.0, EpicACGRenderType.BLOOD_THIRSTY_PARTICLE_TEX);
        }
    }
}

